
// AppController.j
// RMSchedulerController
//
// Created by Alonso Villanueva

@import <Foundation/Foundation.j>
@import <AppKit/AppKit.j>
@import <MapKit/MKMapView.j>
@import <AppKit/CPTextField.j>
@import <AppKit/CPApplication.j>
@import <Foundation/CPURLRequest.j>
@import "AppController.j"
@import "JasperSoftReporter.j"



// var appCont; //comment 2017-03-03





@implementation RMSReportTecnicianController : RMControllerObject {


	CPPanel repoPane;
	
	id persPopu;	
	
	id dateStarText;
	id dateEndText;
	id datePickStarPane;
	id datePickEndPane;
	id idenOrki;
	id imei;
	id arraRepo;
	id inde;
	id jasp;
  	id dictRepo;
  	id urlRepo;
  	id indeRepo;
  	id indeRepoSear;
  	id rasEven;
  	
  	id emaiComm;
  	
  	id repoTabl;
  	id sear;
  	id persPopu;
  	id repoPopu;
  	
}



- (id) init:(id)paraAppCont {
	[super init];
 	
 	appCont = paraAppCont;
	dataBase = [appCont getDataBase];
	repoPane = NULL;
	dateStarText = NULL;
	dateEndText = NULL;
	idenOrki = "orkin_cr";
	//jasp = [[JasperSoftReporter alloc] init];
	jasp = [[JasperSoftReporter alloc] init:appCont];	
	[jasp organizationCodeSet:[appCont getOrgaCode] ];
	[jasp cgiSetHost:[appCont getcgiHost] server:[appCont getcgiServ]];
	dictRepo = NULL;
	urlRepo = NULL;
	arraRepo = NULL;
	arraRepo = NULL;
	rasEven = "0094";
	inde = -1;
	indeRepo = -1;
	emaiComm = "";
	indeRepoSear = -1;
	sear = false;
	imei = "";

	return self;
}




- (void)  applicationQuit {

	if ( repoPane ) {
		[repoPane orderOut:0];
		[repoPane release];
	}
	if (persPopu) { [persPopu release];}
	if (repoPopu) { [repoPopu release];}
	if (arraRepo) { [arraRepo  release];}
	if (dateStarText) { [dateStarText  release];}
	if (dateEndText) {dateEndText [dateEndText  release];}
	if (datePickStarPane) { [datePickStarPane  release];}
	if (datePickEndPane) { [datePickEndPane  release];}
	if (idenOrki) { [ idenOrki release];}
	if (dictRepo) { [ dictRepo release];}
	if (urlRepo) { [urlRepo  release];}
	if (emaiComm) { [ emaiComm release];}
	if (rasEven) { [ rasEven release];}
	if (inde) { [ inde release];}
	if (indeRepo) { [ indeRepo release];}
	if (indeRepoSear) { [ indeRepoSear release];}
	if (sear) { [ sear release];}
	if (imei) { [ imei release];}
	[jasp applicationQuit];
	if (jasp) { [jasp  release];}
	
}





//





- (void) datePickerStartPanel:(id)sender {

	if ( datePickStarPane ) {
		[datePickStarPane orderFront:self];
	}else{
	
	var fram = CGRectMake(350,150,144,148);
	datePickStarPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask]; 
	[datePickStarPane setFloatingPanel:YES];
	[datePickStarPane setTitle:@"Fecha Inicio"];
	[datePickStarPane orderFront:self];

	var paneContView = [datePickStarPane contentView];

	fram = CGRectMake(0,0,144,148);
	var datePick = [[CPDatePicker alloc] initWithFrame:fram];
	[datePick setBackgroundColor:[CPColor whiteColor]];
	[datePick setTimeZone:[CPTimeZone defaultTimeZone]];
	[datePick setDatePickerElements:128];
	var dpe = [datePick datePickerElements];
	[datePick setDatePickerStyle:1];
	var dps = [datePick datePickerStyle];
	[datePick setDateValue:[CPDate date]];
	[datePick setObjectValue:[CPDate date]];
	[datePick setTarget:self];
	[datePick setAction:@selector(datePickerStartDateChange:)];
	//alert("dpe="+dpe+"  dps="+dps);
	
	[paneContView addSubview:datePick];
	}
}



- (void) datePickerStartDateChange:(id)sender {
	[dateStarText setStringValue:[[[sender dateValue] description] substringToIndex:10]];
	[datePickStarPane close];
}



- (void) datePickerEndPanel:(id)sender {

	if ( datePickEndPane ) {
		[datePickEndPane orderFront:self];
	}else{
	var fram = CGRectMake(350,150,144,148);
	datePickEndPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask]; 
	[datePickEndPane setFloatingPanel:YES];
	[datePickEndPane setTitle:@"Fecha Final"];
	[datePickEndPane orderFront:self];

	var paneContView = [datePickEndPane contentView];

	fram = CGRectMake(0,0,144,148);
	var datePick = [[CPDatePicker alloc] initWithFrame:fram];
	[datePick setBackgroundColor:[CPColor whiteColor]];
	[datePick setTimeZone:[CPTimeZone defaultTimeZone]];
	[datePick setDatePickerElements:128];
	var dpe = [datePick datePickerElements];
	[datePick setDatePickerStyle:1];
	var dps = [datePick datePickerStyle];
	[datePick setDateValue:[CPDate date]];
	[datePick setObjectValue:[CPDate date]];
	[datePick setTarget:self];
	[datePick setAction:@selector(datePickerEndDateChange:)];
	//alert("dpe="+dpe+"  dps="+dps);
	
	[paneContView addSubview:datePick];
	}
}



- (void) datePickerEndDateChange:(id)sender {
	[dateEndText setStringValue:[[[sender dateValue] description] substringToIndex:10]];
	[datePickEndPane close];
}

- (void) generateReport:(id)sender {
	if(indeRepoSear <= 0){
		[glblAlerPane showWithMessage:@"Atencion" info:"Seleccione un tipo de reporte."];
	}else if(indeRepoSear == 1){
		[self generateReportHojaServicio:self];
	}else if(indeRepoSear == 2){
		[self generateReportCertificadoServicio:self];
	}

}

- (void) generateReportHojaServicio:(id)sender {
	if(inde < 0){
		[glblAlerPane showWithMessage:@"Atencion" info:"No hay reporte seleccionado."];
		return;
	}
	
	var jaspTabl = "jsprFinalReport";
	var striStartDate = [[dateStarText stringValue] substringToIndex:10];
	var striEndDate = [[dateEndText stringValue] substringToIndex:10];
	var randCode =  [ [CPString UUID] substringToIndex:12];
	imei = "863451031422406";
	
	urlRepo = NULL;
	var titleRepo = "";
	var titleHeadList = "";
	
	titleHeadList = "Producto Utilizado:sc:Número de Lote:sc:Sitio Tratado:sc:Método de Aplicación:sc:Dosis:sc:Cantidad:sc:Observaciones De Plaga Presente";	
			
	//titleRepo = namePers + " " + lastNamePers + " " +striStartDate + " - " +striEndDate;
	titleRepo = "Hoja de Servicio"; 
 	//Programación: startDate - EndDate:sc:Name
	


   var arra = [[arraRepo objectAtIndex:inde] valueList];
   var quer = "SELECT TransactionDate,TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0094%' and currentIndex = '"+arra[0]+"'  LIMIT 1;";      
   var arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
   var valu = [ [arraAux objectAtIndex:0] valueList ];
   var starDate = valu[0];
   var striTran = valu[1];
   var arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   
   var paraRepo = [CPArray array];
   for (var i = 1; i < [ arraTempStri count]; i++){
   		valu = arraTempStri[i];
   		valu = [valu componentsSeparatedByString:"#EQ#"];
   		[paraRepo addObject:valu[1]];
   
   }
   quer = "SELECT TransactionDate,TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0095%' and TransactionDate >= '"+starDate+"' LIMIT 1;";    
   arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
   valu = [ [arraAux objectAtIndex:0] valueList ];
   var endDate = valu[0];
   striTran = valu[1];
   var arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   
   for (var i = 1; i < [ arraTempStri count]; i++){
   		valu = arraTempStri[i];
   		valu = [valu componentsSeparatedByString:"#EQ#"];
   		[paraRepo addObject:valu[1]];
   
   }
	
	quer = "SELECT TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0098%' AND TransactionDate > '"+starDate+"'  and transactionDate < '"+endDate+"' ;";    
   var begiSql = "INSERT INTO " + dataBase + "." + jaspTabl + " (reportCode,FIELD01,FIELD02,FIELD03,FIELD04,FIELD05,FIELD06,FIELD07) VALUES " ;
   var middSql = "";
   arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
   var arraTempRepo = [CPArray array];
   for (var i = 0; i < [ arraAux count]; i++){
   		striTran = [ [arraAux objectAtIndex:i] valueList ][0];
   		arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   		arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   		arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   		var tempRow = [CPArray array];
   		for (var j = 1; j < [ arraTempStri count]; j++){
   			striTran = arraTempStri[j];
   			striTran = [striTran componentsSeparatedByString:"#EQ#"];
   			[tempRow addObject:striTran[1]];
   		}
   		middSql += " ('" + randCode + "','" + tempRow[0] + "','" + tempRow[1]+ "','" + tempRow[2] + "','"  + tempRow[3] + "','" + tempRow[4];
   		middSql +=  "','" + tempRow[5] + "','" + tempRow[6] + "')";
   		if((i+1) != [ arraAux count]){
   			middSql += ",";
   		}
   }
   quer =  begiSql + middSql + ";" ;
   [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
     
    
    //alert("repoCode" + randCode + "title " + titleRepo);
    
    dictRepo = [[CPDictionary alloc] init];
    [dictRepo setObject:paraRepo[5]  forKey:"service" ];
    [dictRepo setObject:titleHeadList forKey:"headList" ];
    [dictRepo setObject:paraRepo[0]  forKey:"client" ];
    [dictRepo setObject:paraRepo[6] forKey:"comment" ];
    [dictRepo setObject:dataBase forKey:"sourceOfData" ];
    [dictRepo setObject:randCode forKey:"repoCode" ];
    [dictRepo setObject:paraRepo[1]  forKey:"date" ];
    [dictRepo setObject:paraRepo[3]  forKey:"timeStart" ];
    [dictRepo setObject:paraRepo[4]  forKey:"timeEnd" ];
    [dictRepo setObject:paraRepo[2]  forKey:"nextVisit" ];
    [dictRepo setObject:titleRepo  forKey:"title" ];
    [dictRepo setObject:"ORKIN de Costa Rica is an independent franchise of Orkin Systems, LLC" forKey:"testFoot"];
	[dictRepo setObject:"HojaServicioOrkinReport" forKey:"myModel" ];
	var jsprMsql = "b14_2"; 
	var myPathTemp = "/reports/" + jsprMsql + "/Orkin";
	[dictRepo setObject:myPathTemp forKey:"myPath" ];
	
    urlRepo = [jasp  buildJasperURL:dictRepo];
   //   [jasp showPreviousView:urlRepo]; 
   window.open(urlRepo);
  
    
}

- (void) generateReportCertificadoServicio:(id)sender {
	if(inde < 0){
		[glblAlerPane showWithMessage:@"Atencion" info:"No hay reporte seleccionado."];
		return;
	}
	
	var jaspTabl = "jsprFinalReport";
	var striStartDate = [[dateStarText stringValue] substringToIndex:10];
	var striEndDate = [[dateEndText stringValue] substringToIndex:10];
	var randCode =  [ [CPString UUID] substringToIndex:12];
	imei = "863451031422406";
	
	urlRepo = NULL;
	var titleRepo = "";
	var titleHeadList = "";
	
	titleHeadList = "Producto Utilizado:sc:Dosis:sc:Cantidad:sc:Sitio Tratado:sc:Método de Aplicación:sc:Equipo";	
			
	//titleRepo = namePers + " " + lastNamePers + " " +striStartDate + " - " +striEndDate;
	titleRepo = "Certificado de Servicio"; 
 	//Programación: startDate - EndDate:sc:Name
	

   var arra = [[arraRepo objectAtIndex:inde] valueList];
   var quer = "SELECT TransactionDate,TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0100%' and currentIndex = '"+arra[0]+"'  LIMIT 1;";       
   var arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
   var valu = [ [arraAux objectAtIndex:0] valueList ];
   var starDate = valu[0];
   var striTran = valu[1];
   var arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   
   var paraRepo = [CPArray array];
   for (var i = 1; i < [ arraTempStri count]; i++){
   		valu = arraTempStri[i];
   		valu = [valu componentsSeparatedByString:"#EQ#"];
   		[paraRepo addObject:valu[1]];
   
   }
   quer = "SELECT TransactionDate,TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0101%' and TransactionDate >= '"+starDate+"' LIMIT 1;";    
   arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];

   valu = [ [arraAux objectAtIndex:0] valueList ];
   var endDate = valu[0];
   striTran = valu[1];
   /**
   var arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];

   
   for (var i = 1; i < [ arraTempStri count]; i++){
   		valu = arraTempStri[i];
   		valu = [valu componentsSeparatedByString:"#EQ#"];
   		[paraRepo addObject:valu[1]];
   
   }**/
	quer = "SELECT TransactionString FROM ricore_giovanni_cr.transactions ";
   quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV=0099%' AND TransactionDate > '"+starDate+"'  and transactionDate < '"+endDate+"' ;";    
   var begiSql = "INSERT INTO " + dataBase + "." + jaspTabl + " (reportCode,FIELD01,FIELD02,FIELD03,FIELD04,FIELD05,FIELD06) VALUES " ;
   var middSql = "";
   arraAux = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
   var arraTempRepo = [CPArray array];
   for (var i = 0; i < [ arraAux count]; i++){
   		striTran = [ [arraAux objectAtIndex:i] valueList ][0];
   		arraTempStri = [striTran componentsSeparatedByString:"#WZRD#"];
   		arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   		arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   		var tempRow = [CPArray array];
   		for (var j = 1; j < [ arraTempStri count]; j++){
   			striTran = arraTempStri[j];
   			striTran = [striTran componentsSeparatedByString:"#EQ#"];
   			[tempRow addObject:striTran[1]];
   		}
   		middSql += " ('" + randCode + "','" + tempRow[0] + "','" + tempRow[1]+ "','" + tempRow[2] + "','"  + tempRow[3] + "','" + tempRow[4];
   		middSql +=  "','" + tempRow[5] + "')";
   		if((i+1) != [ arraAux count]){
   			middSql += ",";
   		}
   }
   quer =  begiSql + middSql + ";" ;
   [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
     
    
    //alert("repoCode" + randCode + "title " + titleRepo);
    
    dictRepo = [[CPDictionary alloc] init];
    [dictRepo setObject:paraRepo[5]  forKey:"service" ];
    [dictRepo setObject:titleHeadList forKey:"headList" ];
    [dictRepo setObject:paraRepo[0]  forKey:"client" ];
    [dictRepo setObject:dataBase forKey:"sourceOfData" ];
    [dictRepo setObject:randCode forKey:"repoCode" ];
    [dictRepo setObject:paraRepo[1]  forKey:"date" ];
    [dictRepo setObject:paraRepo[3]  forKey:"timeStart" ];
    [dictRepo setObject:paraRepo[4]  forKey:"timeEnd" ];
    [dictRepo setObject:paraRepo[2]  forKey:"nextVisit" ];
    [dictRepo setObject:titleRepo  forKey:"title" ];
    [dictRepo setObject:"ORKIN de Costa Rica is an independent franchise of Orkin Systems, LLC" forKey:"testFoot"];
	[dictRepo setObject:"CertificadoServicioOrkinReport" forKey:"myModel" ];
	var jsprMsql = "b14_2"; 
	var myPathTemp = "/reports/" + jsprMsql + "/Orkin";
	[dictRepo setObject:myPathTemp forKey:"myPath" ];
	
    urlRepo = [jasp  buildJasperURL:dictRepo];
   //   [jasp showPreviousView:urlRepo]; 
   window.open(urlRepo);
  
    
}


- (void) persSelectionPopUp:(id)sender {
	var inde = [persPopu indexOfSelectedItem];
	sear = true;
}

- (void) repoSelectionPopUp:(id)sender {
	indeRepo = [repoPopu indexOfSelectedItem];
	if(indeRepo == 1){
		rasEven = "0094";
	}else if(indeRepo == 2){
		rasEven = "0100";
	}
}

- (void) reportsPanel {
	return repoPane;
}


- (void) reportsPanel:(id)sender {

	var horiPos1 = 10;
	var horiPos2 = horiPos1 + 100;
	var horiPos3 = 390;
	var horiPos4 = horiPos3 + 100;

	var horiTextWidt = 200;
	var horiPosiOffs = -4;
	var horiPosi = 200;

	var vertPosi = 20;
	var vertPosiOffs = -4;
	var vertIncr = 26;
	var vertLineHeig = 30;

	var paneWidt = 850;
	var paneHeig = 400;
	var tablWidt = 430;
	var tablHeig = 150;
	
	var x = 10 + Math.random()*40;
	var y = 60 + Math.random()*40;
	var fram = CGRectMake(x,y, paneWidt,paneHeig);

	repoPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask|CPResizableWindowMask]; 
	[repoPane setFloatingPanel:YES]; 
	[repoPane orderFront:self];
	[repoPane setTitle:@"Panel Reportes Tecnicos"];
	
	var paneContView = [repoPane contentView];
	[paneContView setBackgroundColor:coloDefaLite];
	[self addBanners:paneContView heightBlue:1. heightOrange:4.];

	var view = paneContView;
	
	vertPosi += 40;	
	labe= [self addTextField:@"Tipo de Reporte:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	
	
	repoPopu = [self addPopupButton:@"Reporte" TFPosX:horiPos2 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[repoPopu setTarget:self];
	[repoPopu setAction:@selector(repoSelectionPopUp:)];
	[repoPopu addItemWithTitle:"Hoja de Servicio"];
	[repoPopu addItemWithTitle:"Certificado de Servicio"];
	
	//Persons
	vertPosi += 40;	
	labe= [self addTextField:@"Empleados:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	
	
	persPopu = [self addPopupButton:@"Empleados" TFPosX:horiPos2 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[persPopu setTarget:self];
	//[persPopu setAction:@selector(persSelectionPopUp:)];
	[persPopu addItemWithTitle:"Brayan"];
		
	vertPosi += 40;
	labe= [self addTextField:@"Fecha Inicio:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	dateStarText = [self addTextField:[[[CPDate date] description] substringToIndex:10] TFPosX:horiPos2-4 TFPosY:vertPosi-4 TFWidth:85 TFHeight:30 VView:view Editable:YES];
	[self addButton:@"DP" TFPosX:horiPos2 + 90 TFPosY:vertPosi-2 TFWidth:50 TFHeight:24  VView:view sizeToFit:NO Action:@selector(datePickerStartPanel:)];
	vertPosi += 40;
	labe= [self addTextField:@"Fecha Final:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	dateEndText = [self addTextField:[[[CPDate date] description] substringToIndex:10] TFPosX:horiPos2-4 TFPosY:vertPosi-4 TFWidth:85 TFHeight:30 VView:view Editable:YES];
	[self addButton:@"DP" TFPosX:horiPos2 + 90 TFPosY:vertPosi-2 TFWidth:50 TFHeight:24  VView:view sizeToFit:NO Action:@selector(datePickerEndPanel:)];

	
	vertPosi += 70;
	[self addButton:@"Buscar" TFPosX:horiPos2  TFPosY:vertPosi-2 TFWidth:80 TFHeight:24  VView:view sizeToFit:NO Action:@selector(searchReports:)];
	horiPos2 += 90;
	[self addButton:@"Generar" TFPosX:horiPos2  TFPosY:vertPosi-2 TFWidth:80 TFHeight:24  VView:view sizeToFit:NO Action:@selector(generateReport:)];
	
	vertPosi = 20;

	labe= [self addTextField:@"Eventos :" TFPosX:horiPos3 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	vertPosi += vertIncr;

	fram= CGRectMake(horiPos3,vertPosi,tablWidt,tablHeig);
	scroView= [[CPScrollView alloc] initWithFrame:fram];

	repoTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[repoTabl setDataSource:self];
	[repoTabl setTarget:self];
	[repoTabl setAction:@selector(repoTableSelection:)];
	[repoTabl setAllowsColumnReordering:YES];
	[repoTabl setUsesAlternatingRowBackgroundColors:YES];
	[repoTabl setAllowsMultipleSelection:YES];
	[repoTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:100];
	[repoTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Location"];
	[[colu headerView] setStringValue:@"Locacion"];
	[colu setWidth:200];
	[repoTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"DateStart"];
	[[colu headerView] setStringValue:@"Fecha"];
	[colu setWidth:100];
	[repoTabl addTableColumn:colu];
	/**
	colu= [[CPTableColumn alloc] initWithIdentifier:@"Personnel"];
	[[colu headerView] setStringValue:@"Personal"];
	[colu setWidth:100];
	[evenTabl addTableColumn:colu];
	**/

	[scroView setDocumentView:repoTabl];
	[view addSubview:scroView];
}


- (void) repoTableSelection:(id)sender {
	inde = [repoTabl selectedRow];
	if ( inde < 0 )
		return;
}

- (void) searchReports:(id)sender {
	if(indeRepo <= 0){
		[glblAlerPane showWithMessage:@"Atencion" info:"Seleccione un tipo de reporte."];
		return;
	}
	indeRepoSear = indeRepo;
	sear = true;
	[repoTabl reloadData];
}

- (int) numberOfRowsInTableView:(CPTableView)tablView {
	var coun= 0;
	var quer;
	if(sear){
		var striStartDate = [[dateStarText stringValue] substringToIndex:10];
		var striEndDate = [[dateEndText stringValue] substringToIndex:10];
		imei = "863451031422406";
		quer = "SELECT currentIndex,TransactionDate,TransactionString FROM ricore_giovanni_cr.transactions ";
    	quer += "WHERE `ObjectIMEI` = '"+imei+"'  and transactionString LIKE '%RAS_EV="+rasEven+"%' and TransactionDate >= '"+striStartDate+"' and TransactionDate <= '"+striEndDate+" 24:59:59';";
		arraRepo = [self query:quer newCgiServ:@"rm_execute_base64_b14_2"];
		coun= [arraRepo count];
		if(coun == 0){
			[glblAlerPane showWithMessage:@"Atencion" info:"No se han encontrado datos."];
		}
	}
	return coun;
}


- (id) tableView:(CPTableView)tablView objectValueForTableColumn:(CPTableColumn)tablColu row:(int)rowInde {
	var headStri= [[tablColu headerView] stringValue];
	var headIden= [tablColu identifier];
	var valu= @"N/A";

		var arra = [[arraRepo objectAtIndex:rowInde] valueList];
		if ( [headStri isEqualToString:@"Fecha"] )
			valu= [arra[1] substringToIndex:10];
		else if ( [headStri isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headStri isEqualToString:@"Locacion"] ){
				var arraTempStri = [arra[2] componentsSeparatedByString:"#WZRD#"];
   				arraTempStri = [arraTempStri[1] componentsSeparatedByString:";,"];
   				arraTempStri = [arraTempStri[0] componentsSeparatedByString:"#SC#"];
   
 	  			var paraTemp = [CPArray array];
   				for (var i = 1; i < [ arraTempStri count]; i++){
   					valu = arraTempStri[i];
   					valu = [valu componentsSeparatedByString:"#EQ#"];
   					[paraTemp addObject:valu[1]];   
			 	}
				valu= paraTemp[0];
			}
	return valu;
}

@end
